<schema xmlns="http://purl.oclc.org/dsdl/schematron">
	<ns uri="http://www.schematron.info/arche" prefix="arc"/>
	<pattern>
		<rule context="arc:tier[@geschlecht='männlich']">
			<report role="error" test="number(arc:alter) &gt; 
									number(//arc:maxReproduktionsalter/arc:tier_art[arc:name=current()/arc:art]/arc:männlich)">Das Männchen ist zu alt, Noah! Es wird sich nicht mehr fortpflanzen können. Sorge für die natürliche Auslese.</report>
		</rule>
	</pattern>
	<pattern>
		<rule context="arc:nutzlast">
			<report role="fatal" test="number(//arc:nutzlast) &lt; sum(// arc:gewicht)">Noah, du hast zu viele Tiere an Bord. Die Ladung überschreitet die Nutzlast deiner Arche.</report>
		</rule>
	</pattern>
	<pattern>
		<rule role="error" context="arc:tier[@fleischfresser='ja']">
			<report test="parent::*/arc:tier[@fleischfresser='nein']">Es gibt Fleischfresser und Pflanzenfresser in einer Unterkunft. Die Tiere sind keine Nahrungsquelle!</report>
			<report test="parent::*/arc:tier/arc:gewicht &lt; (arc:gewicht div 2)">Noah, dieser Fleischfresser ist zu stark (schwer) für seinen Zimmergenossen. Er könnte ihn als Nahrungsquelle benutzen.</report>
		</rule>
	</pattern>
	<pattern>
		<rule context="arc:tier">
			<report role="warn" test="count(//arc:tier[arc:art=current()/arc:art]) &gt; 2">In der Arche gibt es mehr als zwei Tiere dieser Art.</report>
			<report test="count(parent::*/arc:tier[arc:art=current()/arc:art]) &lt; 2">In dieser Unterkunft gibt es weniger als zwei Tiere dieser Art.</report>
			<assert test="count(parent::*/arc:tier[arc:art=current()/arc:art][@geschlecht='männlich'])=1">Ein Paar muss immer aus einem Männchen und einem Weibchen bestehen.</assert>
		</rule>
	</pattern>
	<pattern>
		<rule context="arc:zimmer">
			<report role="info" test="count(arc:tier) &gt; 6">Noah, bringst du zu viele Tiere in einem Zimmer unter, könnte sich das schlecht auf die Zimmergemeinschaft auswirken! Du solltest nicht mehr als 6 Tiere in einem Zimmer unterbringen.</report>
		</rule>
	</pattern>
</schema>
